<?php

namespace VM\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Groups as AnnotationGroups;
use JMS\Serializer\Annotation\Type;
use JMS\Serializer\Annotation\SerializedName;

/**
 * Offer
 *
 * @ORM\Table(name="offers")
 * @ORM\Entity(repositoryClass="VM\ApiBundle\Repository\OfferRepository")
 *
 * @ORM\HasLifecycleCallbacks
 *
 * @ExclusionPolicy("all")
 */
class Offer
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     *
     * @Expose
     * @AnnotationGroups({"offersDetails"})
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=255)
     *
     * @Expose
     * @AnnotationGroups({"offersDetails"})
     */
    private $name;

    /**
     * @var text
     *
     * @ORM\Column(name="efficiency", type="text")
     *
     * @Expose
     * @AnnotationGroups({"offersDetails"})
     */
    private $efficiency = '';

    /**
     * @var float
     *
     * @ORM\Column(name="price", type="decimal", precision=9, scale=2)
     *
     * @Expose
     * @AnnotationGroups({"offersDetails"})
     */
    private $price;

    /**
     * @var boolean
     *
     * @ORM\Column(name="only_one", type="boolean")
     */
    private $onlyOne = false;

    /**
     * @var integer
     *
     * @ORM\Column(name="parentId", type="integer", nullable=true)
     *
     * @Expose
     * @AnnotationGroups({"offersDetails"})
     */
    private $parentId;

    /**
     * @ORM\ManyToOne(targetEntity="Offer", inversedBy="children")
     * @ORM\JoinColumn(name="parentId", referencedColumnName="id")
     */
    private $parent;

    /**
     * @ORM\OneToMany(targetEntity="Offer", mappedBy="parent")
     *
     * @Expose
     * @AnnotationGroups({"offersDetails"})
     */
    private $children;

    /**
     * @ORM\OneToMany(targetEntity="CompanyOffer", mappedBy="offer")
     */
    protected $roundOffers;

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return Offer
     */
    public function setName($name)
    {
        $this->name = $name;
    
        return $this;
    }

    /**
     * Get name
     *
     * @return string 
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set efficiency
     *
     * @param string $efficiency
     * @return Offer
     */
    public function setEfficiency($efficiency)
    {
        $this->efficiency = $efficiency;
    
        return $this;
    }

    /**
     * Get efficiency
     *
     * @return string 
     */
    public function getEfficiency()
    {
        return $this->efficiency;
    }
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->children = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Set parentId
     *
     * @param integer $parentId
     * @return Offer
     */
    public function setParentId($parentId)
    {
        $this->parentId = $parentId;
    
        return $this;
    }

    /**
     * Get parentId
     *
     * @return integer 
     */
    public function getParentId()
    {
        return $this->parentId;
    }

    /**
     * Set parent
     *
     * @param \VM\ApiBundle\Entity\Offer $parent
     * @return Offer
     */
    public function setParent(\VM\ApiBundle\Entity\Offer $parent = null)
    {
        $this->parent = $parent;
    
        return $this;
    }

    /**
     * Get parent
     *
     * @return \VM\ApiBundle\Entity\Offer 
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Add children
     *
     * @param \VM\ApiBundle\Entity\Offer $children
     * @return Offer
     */
    public function addChildren(\VM\ApiBundle\Entity\Offer $children)
    {
        $this->children[] = $children;
    
        return $this;
    }

    /**
     * Remove children
     *
     * @param \VM\ApiBundle\Entity\Offer $children
     */
    public function removeChildren(\VM\ApiBundle\Entity\Offer $children)
    {
        $this->children->removeElement($children);
    }

    /**
     * Get children
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getChildren()
    {
        return $this->children;
    }

    /**
     * Set price
     *
     * @param string $price
     * @return Offer
     */
    public function setPrice($price)
    {
        $this->price = $price;
    
        return $this;
    }

    /**
     * Get price
     *
     * @return string 
     */
    public function getPrice()
    {
        return $this->price;
    }

    /**
     * Set onlyOne
     *
     * @param boolean $onlyOne
     * @return Offer
     */
    public function setOnlyOne($onlyOne)
    {
        $this->onlyOne = $onlyOne;
    
        return $this;
    }

    /**
     * Get onlyOne
     *
     * @return boolean 
     */
    public function getOnlyOne()
    {
        return $this->onlyOne;
    }

    /**
     * Add roundOffers
     *
     * @param \VM\ApiBundle\Entity\CompanyOffer $roundOffers
     * @return Offer
     */
    public function addRoundOffer(\VM\ApiBundle\Entity\CompanyOffer $roundOffers)
    {
        $this->roundOffers[] = $roundOffers;
    
        return $this;
    }

    /**
     * Remove roundOffers
     *
     * @param \VM\ApiBundle\Entity\CompanyOffer $roundOffers
     */
    public function removeRoundOffer(\VM\ApiBundle\Entity\CompanyOffer $roundOffers)
    {
        $this->roundOffers->removeElement($roundOffers);
    }

    /**
     * Get roundOffers
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getRoundOffers()
    {
        return $this->roundOffers;
    }
}